# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 6
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR6_strategy.txt
# LLM Suggested Fallback: Not Provided

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR6(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Initial Rounds (1-3): Cooperate to build trust
    if current_round <= 3:
        return "C"
    
    # Check opponent's behavior in initial rounds
    early_defects = opp_history[:3].count("D")
    
    # Mid Rounds (4-7)
    if 4 <= current_round <= 7:
        if early_defects >= 2:
            # Tit-for-Two-Tats: Defect only after two consecutive opponent defects
            if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
                return "D"
            else:
                return "C"
        else:
            return "C"
    
    # Final Rounds (8-10)
    if current_round >= 8:
        total_defects = opp_history.count("D")
        defect_rate = total_defects / len(opp_history)
        
        if defect_rate >= 0.4:
            # Exploit opponent's trust in last two rounds
            if current_round >= 9:
                return "D"
            else:
                return "C"
        else:
            # Continue cooperating if opponent mostly cooperated
            return "C"
    
    # Default fallback (shouldn't reach here)
    return "C"